#ifndef QRFEFIFO_H
#define QRFEFIFO_H

#include <QIODevice>
#include <QMutex>

class QrfeFifo : public QIODevice
{
    Q_OBJECT

public:
	QrfeFifo(QObject *parent = 0);
	virtual ~QrfeFifo();

    virtual bool	open ( OpenMode mode );

	virtual bool	reset ();
	virtual qint64	bytesAvailable () const;

    quint64 prepend ( const QByteArray& data );

protected:
	virtual qint64	readData ( char * data, qint64 maxSize );
	virtual qint64	writeData ( const char * data, qint64 maxSize );

private slots:
	void	_q_emitSignals();

protected:
	QByteArray		m_buffer;
	QMutex*			m_mutex;
};

#endif // QRFEFIFO_H
